﻿using Microscopic_Traffic_Simulator___Model.TrafficObjects;
using System;
using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.GeometricObjects.Nodes
{
    /// <summary>
    /// Node containing sensor.
    /// </summary>
    [Serializable]
    public class SensorNode : InnerNode
    {
        /// <summary>
        /// Sensor in the node.
        /// </summary>
        private Sensor sensor;
        /// <summary>
        /// Sensor in the node.
        /// </summary>
        public Sensor Sensor { get { return sensor; } }

        /// <summary>
        /// Initialization of the sensor node.
        /// </summary>
        /// <param name="location">Node location.</param>
        /// <param name="t">Value in interval (0, 1) determining location on the lane.</param>
        /// <param name="sensor">Sensor to be placed in the node.</param>
        public SensorNode(Point location, double t, Sensor sensor)
            : base(location, t)
        {
            this.sensor = sensor;
        }
    }
}
